from importlib.machinery import SourceFileLoader
import os

moduleMap = {}

def loadModule(moduleName):
    modulesLocation = os.path.dirname(os.path.realpath(__file__))
    modules = os.listdir(modulesLocation)
    if moduleName not in modules: raise Exception('Module {} not found'.format(moduleName))
    try:
        return SourceFileLoader('main', os.path.join(modulesLocation, moduleName, 'main.py')).load_module()
    except Exception as e:
        return str(e)


async def call(module, method, params=None):
    if module not in moduleMap: moduleMap[module] = loadModule(module)
    
    if isinstance(moduleMap[module], str):
        raise Exception('Error importing module {}: {}'.format(
            module, moduleMap[module]))
    return await getattr(moduleMap[module], method)(params)