# omnis_zip

## Overview

The omnis_zip module allows you to work with zip files with the jsworker.

## Example

An example of using this worker module in your Omnis code:

```
Do lRow.$cols.$add("path",kCharacter,kSimplechar)
Calculate lRow.path as iZipPath
Do iJS.$callmethod("omnis_zip","loadZip",lRow,kTrue,lErrorText) Returns lOK
```
You should implement `$methodreturn()` and `$methoderror()` to obtain the return value or error.

## Methods

The methods supplied in omnis_zip for use:

### newZip()

Create a new empty ZIP file
newZip() expects no parameters so the 3rd parameter of $callmethod can be ignored.

```
Do $cinst.$callmethod("omnis_zip","newZip")
```

### addFolder(path)

Add a folder to the ZIP file.
Folder paths are relative to the top of the ZIP file, so start with a name.
This must be followed by additional folder names.  Intermediate folders which do not exist are also created.

```
# lRow should be a row defined as having a single character column named "path"
Do lRow.$assigncols("folder_name/nested_folder_name")
Do $cinst.$callmethod("omnis_zip","addFolder",lRow)
```

### addFiles(path, inputFile)

Add a file or files to the ZIP file, given the path and inputFile.

```
# lFilesList should be a list defined as having two character columns
# The first named "path", containing the path of the file in the zip
# The second named "inputFile", containing the path on the file system of the input file
Do $cinst.$callmethod("omnis_zip","addFiles",lFileList)
```

### saveZip(outputFile, [compressionLevel=6])

Save the ZIP file to the path specified in outputFile, using compression level specified in compressionLevel, which defaults to 6.

```
# lRow should be a row defined as having at least a single character column named "outputFile"
# A second optional column "compressionLevel" should be defined as an integer
Do lRow.$assigncols(con(iYourDirectoryPathHere,sys(9),"archive_name.zip"))
Do $cinst.$callmethod("omnis_zip","saveZip",lRow)
```

### loadZip(path) : `List`

Load the ZIP file specified in path.
Generates a content list as the return value passed to $methodreturn.

```
# lRow should be a row defined as having a sinlge character column named "path"
Do lRow.$assigncols("folder_name/archive_name.zip")
Do $cinst.$callmethod("omnis_zip","loadZip",lRow)

# In $methodreturn() the "contents" column will contain a list of the zip contents
```

### extractFile(path) : `Binary`

Extracts a file from the ZIP file (at path obj.fullPath in the ZIP) and sends its data to $methodreturn

```
# lRow should be a row defined as having a sinlge character column named "path"
Do lRow.$assigncols("my_file.jpg")
Do $cinst.$callmethod("omnis_zip","ExtractFile",lRow)

# In $methodreturn() the data will be available in the return parameter
```
