# Creating 'Simple' Modules

To create a simple module (contained within a single file, and not likely to be 
redistributed individually), add a .js file to this directory, and define the module within it.

Consider using **template_module.js** as a starting point.

# Importing Other Modules
    
To import a module to use within your own, use the `require()` function to import the module and assign to a variable:

    const myPackage = require('myPackage');


# Adding Dependencies

Use `npm install <package>` from within a module's directory to install 3rd-party dependencies
for your module. 


# Creating Modules As Packages

If your module is going to comprise multiple files, or you intend to redistribute it as a standalone 
module for other installations, it makes sense to create a proper package for your module.

 1) Create a directory for your module.
 2) From the commandline: `cd` into your module's directory and run `npm init`
 3) Follow through the instructions to generate a *package.json* file for your module.
 4) Create a **.js** file for your module, whose filename matches the **main** entrypoint defined in your *package.json*.
 5) Run `npm install <package>` to install any dependencies for your module.
 
Add your module package as a **local** dependency of the main **jsworker** project, as follows:


# Adding Dependencies To Local Packages
 
 Run `npm install -save <package>` to save a local package to the jsworker module's package dependencies.
 
 
# Deploying To Other Platforms/Architectures

Some node packages may include platform-specific binary data, which cannot be copied between OS platforms (e.g. macOS & Windows),
or architectures (E.g. 32 & 64-bit).

When you want to deploy to other platforms, the fact that things are defined as Node packages makes this relatively easy:

 1) Copy the whole **jsworker** folder, **without** any **node_modules** folders (in the main directory, or in submodules) to the new platform.
 2) Make sure **npm** is installed on the new machine.
 3) `cd` into the **jsworker** folder and run `npm install`.
 
 The *package.json* in the *jsworker* folder defines all of the dependencies, and npm will fetch them all for the current platform.


 # Modules Which Fail To Load

 If your module is failing to load, often the best way to determine the problem is to use node directly from the terminal, to try to open your module file individually.

 E.g. `$ node jsworker/myModule.js`

This will often give you a stack trace detailing issues preventing the file from loading.