/*
 * Decompiled with CFR 0.152.
 */
package net.omnis.JavaWorker;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PIDMonitor {
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public PIDMonitor(Integer pPID) {
        Runnable checkPIDTask = () -> {
            if (!PIDMonitor.isProcessRunning(pPID)) {
                this.scheduler.shutdown();
                System.exit(0);
            }
        };
        this.scheduler.scheduleAtFixedRate(checkPIDTask, 0L, 5L, TimeUnit.SECONDS);
    }

    private static boolean isProcessRunning(int pPID) {
        String os = System.getProperty("os.name").toLowerCase();
        try {
            if (os.contains("win")) {
                String line;
                Process process = Runtime.getRuntime().exec("tasklist /FI \"PID eq " + pPID + "\"");
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    if (!line.contains(Integer.toString(pPID))) continue;
                    return true;
                }
            } else if (os.contains("nix") || os.contains("nux") || os.contains("mac")) {
                String line;
                Process process = Runtime.getRuntime().exec("ps -p " + pPID);
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    if (!line.contains(Integer.toString(pPID))) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

