/*
 * Decompiled with CFR 0.152.
 */
package net.omnis.JavaWorker;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.omnis.JavaWorker.BadOmnisPID;
import net.omnis.JavaWorker.ClassNotDerivedFromOModule;
import net.omnis.JavaWorker.PIDMonitor;
import net.omnis.OmnisCalls.OModule;
import net.omnis.OmnisCalls.SendError;
import net.omnis.OmnisCalls.SendResponse;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@SpringBootApplication
@RestController
public class JavaWorkerApplication {
    private static final Class<?>[] METHOD_ARG_SIGNATURE = new Class[]{Map.class};
    private Map<String, Class<?>> smClassesMap = new HashMap();
    private Map<String, Object> smObjectsInstancesMap = new HashMap<String, Object>();
    private static boolean smDebug = false;
    private static String smListeningPortFilepath;
    private static String smStacktraceFilepath;
    private static Integer smOmnisPID;

    private Map<String, Object> parseBody(String pRequestBody) {
        Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
        return (Map)new Gson().fromJson(pRequestBody, mapType);
    }

    private static HttpHeaders getJsonHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    private static void log(String pString) {
        System.out.println(pString);
    }

    private Class<?> loadClass(String pClassName) throws ClassNotFoundException, ClassNotDerivedFromOModule {
        if (this.smClassesMap.containsKey(pClassName)) {
            if (smDebug) {
                JavaWorkerApplication.log(String.format("Loading definition for class: %s from cache of class definitions", pClassName));
            }
            return this.smClassesMap.get(pClassName);
        }
        Class<?> dynamicClass = Class.forName(pClassName);
        if (!OModule.class.isAssignableFrom(dynamicClass)) {
            if (smDebug) {
                JavaWorkerApplication.log(String.format("Class: %s is not derived from OModule", pClassName));
            }
            throw new ClassNotDerivedFromOModule(String.format("Class: %s is not derived from OModule", pClassName));
        }
        this.smClassesMap.put(pClassName, dynamicClass);
        if (smDebug) {
            JavaWorkerApplication.log(String.format("Added class: %s to cache of class defintions", pClassName));
        }
        return dynamicClass;
    }

    private Object retrieveObjectInstanceFromCache(String pClassName) {
        if (this.smObjectsInstancesMap.containsKey(pClassName)) {
            if (smDebug) {
                JavaWorkerApplication.log(String.format("Retrieving existing object instance from cache, for class: %s", pClassName));
            }
            return this.smObjectsInstancesMap.get(pClassName);
        }
        return null;
    }

    private void storeObjectInstanceInCache(String pClassName, Object pObjectInstance) {
        if (smDebug) {
            JavaWorkerApplication.log(String.format("Storing object instance in cache, for class: %s", pClassName));
        }
        this.smObjectsInstancesMap.put(pClassName, pObjectInstance);
    }

    private Object createObjectInstance(String pClassName) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, ClassNotDerivedFromOModule, IllegalAccessException, InvocationTargetException {
        Class<?> dynamicClass = this.loadClass(pClassName);
        Object instance = dynamicClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (smDebug) {
            JavaWorkerApplication.log(String.format("Created a new object instance for class: %s", dynamicClass.getName()));
        }
        return instance;
    }

    private Method getMethod(String pClassName, String pMehtodName) throws ClassNotFoundException, ClassNotDerivedFromOModule, NoSuchMethodException {
        Class<?> dynamicClass = this.loadClass(pClassName);
        Method method = dynamicClass.getDeclaredMethod(pMehtodName, METHOD_ARG_SIGNATURE);
        if (smDebug) {
            JavaWorkerApplication.log(String.format("Obtained definition of method: %s from definition of class: %s", method.getName(), dynamicClass.getName()));
        }
        return method;
    }

    private static void writeStrackTraceToFile(Exception pEx) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(smStacktraceFilepath));
            PrintStream ps = new PrintStream(fos);
            pEx.printStackTrace(ps);
        }
        catch (FileNotFoundException efile) {
            pEx.printStackTrace();
        }
    }

    private static void startPidMonitor() throws BadOmnisPID {
        if (smOmnisPID == 0) {
            throw new BadOmnisPID("Omnis PID is zero.");
        }
        Thread pidMonitorThread = new Thread(() -> new PIDMonitor(smOmnisPID));
        pidMonitorThread.setDaemon(true);
        pidMonitorThread.start();
    }

    private static void parseArgs(String[] pArgs) {
        block6: for (int i = 0; i < pArgs.length - 1; ++i) {
            switch (i) {
                case 0: {
                    smListeningPortFilepath = pArgs[i];
                    continue block6;
                }
                case 1: {
                    smOmnisPID = Integer.parseInt(pArgs[i]);
                    continue block6;
                }
                case 2: {
                    smStacktraceFilepath = pArgs[i];
                    continue block6;
                }
                case 3: {
                    if (!"DEBUG".equals(pArgs[i])) continue block6;
                    smDebug = true;
                    JavaWorkerApplication.log("WARNING: JAVA WORKER DEBUGGING ENABLED");
                }
            }
        }
    }

    public static void writePortToFile(Integer pPort) {
        try {
            String jsonPort = String.format("{\"port\": %d}", pPort);
            Files.write(Paths.get(smListeningPortFilepath, new String[0]), jsonPort.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            JavaWorkerApplication.writeStrackTraceToFile(e);
            System.exit(1);
        }
    }

    @PostMapping(value={"/call/{module}/{methodname}"})
    public ResponseEntity<String> callDynamicModule(@PathVariable String module, @PathVariable String methodname, @RequestBody String requestBody) {
        if (smDebug) {
            JavaWorkerApplication.log("");
            JavaWorkerApplication.log("=== INCOMING REQUEST ===");
        }
        try {
            Object instance;
            Map<String, Object> params = this.parseBody(requestBody);
            if (smDebug) {
                JavaWorkerApplication.log(String.format("Request module: %s", module));
                JavaWorkerApplication.log(String.format("Request method: %s", methodname));
                JavaWorkerApplication.log(String.format("Request body: %s", requestBody));
                JavaWorkerApplication.log(String.format("Parsed request body: %s", params));
            }
            if ((instance = this.retrieveObjectInstanceFromCache(module)) == null) {
                instance = this.createObjectInstance(module);
                this.storeObjectInstanceInCache(module, instance);
            }
            Method method = this.getMethod(module, methodname);
            Object result = method.invoke(instance, params);
            if (smDebug) {
                JavaWorkerApplication.log(String.format("Invoked method: %s from module: %s", method.getName(), module));
            }
            if (result instanceof SendError) {
                if (smDebug) {
                    JavaWorkerApplication.log(String.format("Method: %s from module: %s returned a SendError: %s", method.getName(), module, ((SendError)result).getData()));
                }
                return ResponseEntity.badRequest().body((Object)((SendError)result).getData());
            }
            if (result instanceof SendResponse) {
                if (smDebug) {
                    JavaWorkerApplication.log(String.format("Method: %s from module: %s returned a SendResponse: %s", method.getName(), module, ((SendResponse)result).getData()));
                }
                return new ResponseEntity((Object)((SendResponse)result).getData(), (MultiValueMap)JavaWorkerApplication.getJsonHeaders(), (HttpStatusCode)HttpStatus.OK);
            }
            if (smDebug) {
                JavaWorkerApplication.log(String.format("Method :%s from module: %s did not return an adequate response, we received: %s", method.getName(), module, result.getClass()));
            }
            return ResponseEntity.badRequest().body((Object)"Java method did not return an adequate response.");
        }
        catch (JsonSyntaxException e) {
            return ResponseEntity.badRequest().body((Object)String.format("Invalid JSON format (request parameters): %s", e.getMessage()));
        }
        catch (ClassNotDerivedFromOModule e) {
            return ResponseEntity.badRequest().body((Object)e.getMessage());
        }
        catch (ClassNotFoundException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Module not found.");
        }
        catch (InstantiationException e) {
            return ResponseEntity.badRequest().body((Object)String.format("Failed instantiating module object: %s", e.getMessage()));
        }
        catch (NoSuchMethodException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Method not found.");
        }
        catch (Exception e) {
            JavaWorkerApplication.writeStrackTraceToFile(e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error occurred (Exception).");
        }
    }

    @GetMapping(value={"/alive"})
    public ResponseEntity<String> checkAlive() {
        return ResponseEntity.ok((Object)"OK");
    }

    public static void main(String[] args) {
        JavaWorkerApplication.parseArgs(args);
        try {
            JavaWorkerApplication.startPidMonitor();
        }
        catch (BadOmnisPID e) {
            JavaWorkerApplication.writeStrackTraceToFile(e);
            if (smDebug) {
                JavaWorkerApplication.log("BadOmnisPID exception has been thrown.");
            }
            System.exit(1);
        }
        SpringApplication.run(JavaWorkerApplication.class, (String[])args);
    }
}

